#!/usr/bin/env node

import fs from 'fs';
import net from 'net';
import express, { json } from 'express';
import http from 'http';
import path from 'path';
import multer from 'multer';
import { Server as SocketIOServer } from 'socket.io';
import { fileURLToPath } from 'url';
import { spawn } from 'child_process';
//import { db, getLogsCount } from './db.mjs';
import { Sequelize, DataTypes } from 'sequelize';
import { allowedNodeEnvironmentFlags } from 'process';
import { parseJsonData } from './parseJsonData.mjs';


// Сохраняем файлы в папку 'uploads'
const upload = multer({ dest: 'uploads/' });


const sequelize = new Sequelize({
    dialect: 'sqlite',
    storage: './log.db'
  });
const logs = sequelize.define('logs', {
  time: DataTypes.STRING,
  level: DataTypes.INTEGER,
  mess: DataTypes.STRING,
});
logs.sync();

var rms_isactive = false;
var currentJsonLength = undefined;
const sleep = ms => new Promise(r => setTimeout(r, ms));
const __filename = fileURLToPath(import.meta.url);
const __dirname = path.dirname(__filename);
const app = express();
const server = http.createServer(app);
export const io = new SocketIOServer(server);
const CONFIG_PATH = '/opt/RMS/detector/settings/';
//const DOTS_FILE = '/tmp/dots2.fifo';
const TRAINING_DAT = CONFIG_PATH + 'training.dat';
const DETECT_JSON = CONFIG_PATH + 'detect.json';
const DIR_DEF_JSON = CONFIG_PATH + 'dir_def.json';
const WEBSETTINGS_JSON = CONFIG_PATH + 'websettings.json';
const buffer = Buffer.alloc(1024); // создаем буфер размером 1024 байта
var logpagenum = 1;
const logs_on_logpage = 100;

export const detect_config = {}
detect_config.detect_json = JSON.parse(fs.readFileSync(DETECT_JSON, 'utf8'));
detect_config.dir_def_json = JSON.parse(fs.readFileSync(DIR_DEF_JSON, 'utf8'));
detect_config.websettings = JSON.parse(fs.readFileSync(WEBSETTINGS_JSON, 'utf8'));
detect_config.trainingstat = "??"

export var status = {}
status.alert = -1000;
status.por = 0;
status.dirs =0;
status.currentMessage = "";

class CircularBuffer {
    constructor(size) {
        this.buffer = [];
        this.head = 0;
        this.tail = 0;
        this.size = size;
    }

    push(item) {
        if (this.buffer.length === this.size) {
            this.buffer[this.tail] = item;
            this.tail = (this.tail + 1) % this.size;
        } else {
            this.buffer.push(item);
        }
    }

    length() {
        var len = this.tail - this.head;
        return (len < 0 ? (len + this.size) : len);
    }

    popArray(count) {
        var buf = this.buffer.slice(this.head, this.head + count);
        this.head = (this.head + count) % this.size;
        return buf;
    }

    pop() {

        while (this.head === this.tail) {
            throw new Error('Buffer is empty');
        }

        const item = this.buffer[this.head];
        this.head = (this.head + 1) % this.size;
        return item;
    }
}
const jsonBuffer = new CircularBuffer(1024);

// Middleware для парсинга multipart/form-data
app.post('/upload', upload.single('filefield'), async (req, res) => {
    // req.file - это 'filefield' файл
    console.log(req.file);

    moveLearnFile(req.file.path)

    restartDetector();
    status.currentMessage = "Файл обучения загружен.";
    io.emit('mess', status.currentMessage);
    addlogs();
    await sleep(5000);
    status.currentMessage = "Перезапуск..";
    io.emit('mess', status.currentMessage);
    addlogs();
    await sleep(5000);
    tryRestartWebserver();
    io.emit('reload');
});

app.use((req, res, next) => {
    res.setHeader('Access-Control-Allow-Origin', '*');
    res.setHeader('Access-Control-Allow-Methods', 'GET, POST, OPTIONS, PUT, PATCH, DELETE');
    res.setHeader('Access-Control-Allow-Headers', 'X-Requested-With,content-type');
    res.setHeader('Access-Control-Allow-Credentials', true);
    next();
});
// Подключаем статические файлы из папки public
app.use(express.static(path.join(__dirname, 'dist')));

//var dotsStream = fs.createReadStream(DOTS_FILE); // Опционально, можно настроить размер буфера
var client_json = new net.Socket();
var client_spectr = new net.Socket();
initClientJson()
initClientSpectr()
connectClientJson();
connectClientSpectr();
var connect_retry_count = 0;

async function notdata() {
    connect_retry_count++;
    if (connect_retry_count>3){
        restartDetector();
        await sleep(10000);
        tryRestartWebserver();
    }else{
    status.alert = -1000
    io.emit('alert', status.alert);
    status.currentMessage = "Нет данных..";
    io.emit('mess', status.currentMessage);
    }

}


export async function addlogs(mess){
    await logs.create({
        time: new Date().toLocaleString('ru-RU', {
            year: 'numeric',
            month: 'numeric',
            day: 'numeric',
            hour: '2-digit',
            minute: '2-digit'
          }),
        level: status.alert,
        mess: mess? mess : status.currentMessage
      });
}

export async function getLogs(){
    var count = await logs.count();
    var logpage_count = Math.floor(count/ logs_on_logpage)+1;
    return {
        'logpagenum': logpagenum,
        'logpage_count': logpage_count,
        'rows': await logs.findAll({ 
            order:[
                ['createdAt', 'DESC'],
            ],
            attributes: ['time', 'level', 'mess'],
            offset: ((logpagenum-1)*logs_on_logpage),
            limit: logs_on_logpage })
    };
}

// Обработчик подключения к сокету
io.on('connection', (socket) => {
    console.log('Пользователь подключился');
    io.emit('alert', status.alert);
    try {
        try {
            const stats = fs.statSync(TRAINING_DAT);
            detect_config.trainingstat=stats.birthtime;
        } catch (err) {
            console.error(err);
        }
        io.emit('detect_config', detect_config);
        io.emit('location',{
            "long": detect_config.websettings.geo_coord[1],
            "lat":detect_config.websettings.geo_coord[0],
            "azimuth":detect_config.websettings.azimuth,
        });
    } catch (e) {
        console.log(e);
    }

    socket.on('disconnect', () => {
        console.log('Пользователь отключился');
    });
    socket.on('save_detect_config', async (detect_config) => {
        console.log(status.por);
        fs.writeFileSync(DETECT_JSON, JSON.stringify(detect_config.detect_json));
        fs.writeFileSync(DIR_DEF_JSON, JSON.stringify(detect_config.dir_def_json));
        fs.writeFileSync(WEBSETTINGS_JSON, JSON.stringify(detect_config.websettings));
        restartDetector();
        if (status.alert == -1000) {
            await sleep(10000);
        }
        tryRestartWebserver();
    });
    socket.on('getNextJournalPage', async (page) => {
        var count = await logs.count();
        var logpage_count = Math.floor(count/ logs_on_logpage)+1;
        if (logpage_count > logpagenum){
            logpagenum++;
        }
        io.emit('journal',JSON.stringify(await getLogs()));

    });
    socket.on('getPrevJournalPage', async (page) => {
        if (1 < logpagenum){
            logpagenum--;
        }
        io.emit('journal',JSON.stringify(await getLogs()));
    });
    socket.on('get_journal', async (page) => {
        logpagenum = 1;
        io.emit('journal',JSON.stringify(await getLogs()));
    });
    socket.on('login', async (passwd) => {
        io.emit('login', passwd==detect_config.websettings.passwd);
    });
});

server.listen(3000, () => {
    console.log('Server running on port 3000');
});
var controlDataReceive = setInterval(notdata, 10000);


function moveLearnFile(file) {
    console.log(file);
    const ls = spawn('sudo', ['mv', '-f', file, TRAINING_DAT]);

    ls.stdout.on('data', (data) => {
        console.log(`stdout: ${data}`);
    });

    ls.stderr.on('data', (data) => {
        console.log(`stderr: ${data}`);
    });

    ls.on('close', (code) => {

    });

}


function restartDetector() {
    const ls = spawn('sudo', ['systemctl', 'restart', 'rmsdetector.service']);

    ls.stdout.on('data', (data) => {
        console.log(`stdout: ${data}`);
    });

    ls.stderr.on('data', (data) => {
        console.log(`stderr: ${data}`);
    });

    ls.on('close', (code) => {

    });

}


async function tryRestartWebserver() {
    while (!rms_isactive) {
        await sleep(1000);
        console.log("1000")

        const ls = spawn('systemctl', ['is-active', 'rmsdetector.service']);

        ls.stdout.on('data', (data) => {
            console.log(`stdout: ${data}`);
            // Обрезаем символы новой строки в stdout для точного сравнения
            const serviceStatus = data.toString().trim();
            console.log(serviceStatus)
            if (serviceStatus === 'active') {
                try{sequelize.close();}catch{}
                restartWebserver();
            }
        });

        ls.stderr.on('data', (data) => {
            console.log(`stderr: ${data}`);
        });

        ls.on('close', (code) => {

        });

    }
}
function restartWebserver() {
    const ls = spawn('sudo', ['systemctl', 'restart', 'rmsserver.service']);

    ls.stdout.on('data', (data) => {
        console.log(`stdout: ${data}`);
    });

    ls.stderr.on('data', (data) => {
        console.log(`stderr: ${data}`);
    });

    ls.on('close', (code) => {
        //dotsStream = fs.createReadStream(DOTS_FILE);
    });

}


// Функция для чтения из Сокета
function initClientJson() {
    client_json.on('data', function (data) {
        var js = "";
        if (data.length == 2) {
            //currentJsonLength = data.readInt16LE();
        } else if (data.length > 2) {
            if (data[0] == "{".charCodeAt(0)) {
                js = data.toString();
            } else {
                js = data.slice(2, data.length);
            }
        }
        clearInterval(controlDataReceive);
        controlDataReceive = setInterval(notdata, 10000);
        if (js === "") return;

        parseJsonData(js);
    });

    client_json.on('close', function () {
        console.log('Соединение закрыто');
    });

    client_json.on('error', async function (err) {
        console.log('Ошибка: ' + err);
        console.log('Ошибка подключения к детектору. Ждем 10 секунд.');
        restartDetector();
        await sleep(10000);
        tryRestartWebserver();

    });
}

function connectClientJson() {
    try {
        client_json.connect(8088, 'localhost', function () {
            console.log('Соединение установлено');
        });
    } catch {
        console.log('Ошибка подключения к детектору. Ждем 10 секунд..');

    }


}
function connectClientSpectr() {
    client_spectr.connect(8089, 'localhost', function () {
        console.log('Соединение client_spectr установлено');
    });
}
function initClientSpectr() {
    client_spectr.on('data', function (data) {
        if ((data.byteLength > 2) && (data.byteLength < 1000)) {
            var offset = ((data.byteLength % 4)==0)?0:2;
            const arrayBuffer = data.buffer.slice(offset, data.byteLength);
            io.emit('spectr', arrayBuffer);
    }
    });

    client_spectr.on('close', function () {
        console.log('Соединение client_spectr закрыто');
    });

    client_spectr.on('error', function (err) {
        console.log('Ошибка: ' + err);
    });
}
