import sqlite3 from 'sqlite3';

export let db = new sqlite3.Database('./log.db', (err) => {
    if (err) {
        console.error(err.message);
    }
    console.log('Connected to the log database.');
});
db.run("CREATE TABLE IF NOT EXISTS 'logs' ('time' text, 'level' int, 'mess' text)", (err) => {
    if (err) {
        return console.error(err.message);
    }
    console.log('Table created');
});

function getCountFromTable(tableName) {
    return new Promise((resolve, reject) => {
      db.get(`SELECT COUNT(*) AS count from '${tableName}'`, (err, row) => {
        if (err) {
          reject(err);
        } else {
          resolve(row.count);
        }
      });
    });
  }

export async function getLogsCount() {
    try {
      const count = await getCountFromTable('logs');
    } catch (err) {
      console.error('Ошибка при подсчёте записей:', err);
    }
  }
