#!/bin/bash
sudo apt update

#install NN service
apt install python3-pip
pip install -r ./nn/nn_service3/req.txt
apt install ffmpeg

# Install Nodejs
sudo apt install curl -y
curl -fsSL https://deb.nodesource.com/setup_20.x | sudo -E bash -
sudo apt install nodejs -y
#######################
echo 'Create detector'
mkdir -p /opt/RMS/detector
cp -rf ./scripts/detector.sh  /opt/RMS/
cp -rf ./scripts/detector/* /opt/RMS/detector/
cp -rf ./scripts/detector/settings/* /opt/RMS/detector/settings/
chmod -R 777 /opt/RMS/detector/settings/*
#############################################

echo 'Create webapp'
npm i 
npm run build
mkdir -p /opt/RMS/web

echo 'Copy files..'
cp -rf ./dist /opt/RMS/web
cp -rf ./*.mjs /opt/RMS/web
cp -rf ./*.json /opt/RMS/web
#############################################

echo 'Create services'
useradd rms -d /home/rms -m -G users -s /bin/bash
chown -R rms:users /opt/RMS/
chmod +x /opt/RMS/web/app.mjs
chmod +x /opt/RMS/detector/AntiD
chmod +x /opt/RMS/detector/nn_microphones

rm -f /etc/sudoers.d/rms
echo "
rms  ALL=NOPASSWD: /bin/systemctl restart rmsdetector.service
rms  ALL=NOPASSWD: /bin/systemctl restart rmsserver.service
rms  ALL=NOPASSWD: /bin/systemctl start rmsserver.service
rms  ALL=NOPASSWD: /bin/systemctl stop rmsserver.service
rms  ALL=NOPASSWD: /bin/mv
" | tee /etc/sudoers.d/rms

rm -f /etc/systemd/system/rmsdetector.service
echo "
[Unit]
Description=RMS Detector Service
After=network.target
StartLimitBurst=100
StartLimitIntervalSec=100

[Service]
User=rms
Group=users
Type=simple
ExecStart=/opt/RMS/detector.sh

[Install]
WantedBy=multi-user.target
" >> /etc/systemd/system/rmsdetector.service

rm -f /etc/systemd/system/rmsserver.service
echo "
[Unit]
Description=RMS Web-server

[Service]
ExecStart=/opt/RMS/web/app.mjs
# Restart=always
Type=simple
User=rms
# Note Debian/Ubuntu uses 'nogroup', RHEL/Fedora uses 'nobody'
Group=users
Environment=PATH=/usr/bin:/usr/local/bin
Environment=NODE_ENV=production
WorkingDirectory=/opt/RMS/web

[Install]
WantedBy=multi-user.target
" >> /etc/systemd/system/rmsserver.service


echo 'Install modules..'
cd /opt/RMS/web/
npm install 


echo "Restart RMS service.."
systemctl daemon-reload
systemctl enable rmsdetector
systemctl restart rmsdetector
systemctl enable rmsserver
systemctl restart rmsserver
echo "Done."


