import Chart from 'chart.js/auto';
import { io } from 'socket.io-client';
   // main.js или main.ts
import styles from './public/css/styles.scss';
import { setAlertLevel } from './setAlertLevel';
import { _getStartAndCountOfVisiblePoints } from 'chart.js/helpers';


const sleep = ms => new Promise(r => setTimeout(r, ms));
export var direct_data = Array.from({ length: 5 })
var por = 0.5
var por_color = "blue"
var currentAlertLevel = 0
var ctx = document.getElementById('verChart').getContext('2d');


const verlabels = Array.from({ length: 100 }, (_, i) => i + 1);
const verdata = {
  labels: verlabels,
  datasets: [
    {
      label: 'MIC1',
      data: Array.from({ length: 100 }, () => null),
      borderColor: 'red',
      backgroundColor: 'rgb(175, 92, 2)',
    },
    {
      label: 'MIC2',
      data: Array.from({ length: 100 }, () => null),
      borderColor: 'green',
      backgroundColor: 'rgb(175, 92, 2)',
    },
    {
      label: 'MIC3',
      data: Array.from({ length: 100 }, () => null),
      borderColor: 'blue',
      backgroundColor: 'rgb(175, 92, 2)',
    },
    {
      label: 'MIC4',
      data: Array.from({ length: 100 }, () => null),
      borderColor: 'yellow',
      backgroundColor: 'rgb(175, 92, 2)',
    },
    {
      label: 'Порог',
      data: Array.from({ length: 100 }, () => null),
      borderColor: 'indigo',
      borderDash: [3, 3],
      tension: 0.1,
      fill: true
    }
  ]
};

const verconfig = {
  type: 'line',
  data: verdata,
  options: {
    scales: {
      x: {
        display: false // Скрыть подписи оси X
      }
    },
    animation: false,
    responsive: true,
    elements: {
      point: {
        radius: 0
      }
    },
    plugins: {
      legend: {
        display: false,
        position: 'top',
        scales: {
          y: {
            beginAtZero: true
          }
        }
      },
      title: {
        display: false,
        text: 'Chart.js Line Chart'
      }
    }
  },
};

const spectrdata = {
  datasets: [
    {
      //label: 'Спектр',
      //data: Array.from({ length: 187 }, () => null),
      backgroundColor: 'indigo',
    },
    
  ]
};
var waterFallCanvas = document.createElement('canvas');
var waterfalldata = Uint8ClampedArray.from({ length: 64 }, (_, i) => 128);
var dataLength = 16;
const spectrPlugin = {
  afterDraw: function (chart, args, options) {
    //const ctx = chart.ctx;
    let canvas = chart.canvas;
    let rect = canvas.getBoundingClientRect();
    
    let height = parseInt(waterfalldata.length/(4*dataLength))
    let imageData = new ImageData(waterfalldata, dataLength, height );

    var tempCanvas = document.createElement('canvas');
    tempCanvas.width = imageData.width;
    tempCanvas.height = imageData.height;
    //console.log(tempCanvas.height)
    tempCanvas.getContext('2d').putImageData(imageData, 0, 0);
    
    waterFallCanvas.height = tempCanvas.height;
   waterFallCanvas.getContext('2d').drawImage(tempCanvas, 40, 0, waterFallCanvas.width-60, tempCanvas.height);

  }
};

const spectrconfig = {
  type: 'bar',
  data: spectrdata,
  plugins: [spectrPlugin],
  options: {
    barPercentage: 1.0,
    categoryPercentage: 1.0,
    scales: {
      x: {
        title: {
          display: false, // Показывать подпись
          text: 'Гц', // Текст подписи
        },
        type: 'linear'
      },
      y: {
        type: 'linear',
        min: 20,
        max: 65,
        borderWidth: 0,
      }
    }
  }
};

Chart.defaults.plugins.legend.display = false;
var verChart = new Chart(document.getElementById('verChart').getContext('2d'), verconfig);
var spectrChart = new Chart(document.getElementById('spectrChart').getContext('2d'), spectrconfig);

window.toggleWinf = toggleWinf;
function toggleWinf(winf_btn){
          //var winf_btn = event.target.id;
          var btn = document.getElementById(winf_btn)
          btn.classList.toggle('btn_checked');
          if (winf_btn == 'spectr_btn'){
            document.getElementById('spectrDiv').style.visibility = btn.classList.contains('btn_checked')?'visible':'';
          }else if(winf_btn == 'ver_btn'){
            document.getElementById('verDiv').style.visibility = btn.classList.contains('btn_checked')?'visible':'';
            setTimeout(()=>{
              document.getElementById('verChart').style.width = null;
            },50);
          }else if(winf_btn == 'journal_btn'){
            document.getElementById('journalDiv').style.visibility = btn.classList.contains('btn_checked')?'visible':'';
          }else if(winf_btn == 'calibr_btn'){
            calibration()
            document.getElementById('verDiv').style.visibility = 'visible';
            setTimeout(()=>{
              document.getElementById('verChart').style.width = null;
            },50);
          }
}

window.calibration = calibration;
function calibration() {
  if (currentAlertLevel != -2) {
    toast('/img/Calibration_l.png','Калибровка','rounded lime darken-1',10000);
    config.detect_json.detect.border = -1;
  } else {
    toast('/img/Calibration_l.png',`Стоп калибровка. Порог=${por}`,'rounded lime darken-1',10000);
    config.detect_json.detect.border = por;
  }
  socket.emit("save_detect_config", config);
}

function updateVerChart(data) {
  if (document.getElementById("verDiv").hidden) return;
  for (let i = 0; i < data.length; i += 4) {
    verChart.data.datasets[0].data.shift();
    verChart.data.datasets[0].data.push(data[i]);
    verChart.data.datasets[1].data.shift();
    verChart.data.datasets[1].data.push(data[i + 1]);
    verChart.data.datasets[2].data.shift();
    verChart.data.datasets[2].data.push(data[i + 2]);
    verChart.data.datasets[3].data.shift();
    verChart.data.datasets[3].data.push(data[i + 3]);
    verChart.data.datasets[4].data.shift();
    verChart.data.datasets[4].data.push(por);
  }
  verChart.data.datasets[4].borderColor = por_color
  verChart.update({
    duration: 800,
    easing: 'easeOutBounce'
  });
}

function updateSpectrChart(data) {
  if (document.getElementById("spectrDiv").hidden) return;
  spectrChart.data.datasets[0].data = data;
  dataLength = data.length;
  //waterfalldata = Array.from({ length: data.length }, (_, i) => -2);
  var hex = dataToColor(data);
  spectrChart.data.datasets[0].backgroundColor = Array.from({ length: data.length }, (_, i) => 0);
  data.forEach((point, index) => {
    spectrChart.data.datasets[0].backgroundColor[index] = hex[index]//numberToOrangeColor(point)//{...dataToColor(data)};
  });
  spectrChart.update();

}


function growWaterFall(wf, addwf) {
  
  if (wf.length < addwf.length){
    return addwf;
  }else{
    var newArray = new Uint8ClampedArray(addwf.length + wf.length);
    newArray.set(addwf,0);
    newArray.set(wf,addwf.length);
    return newArray.subarray(0, 4*dataLength*150);
  }
}

// Функция перевода числа в цвет
function dataToColor(data) {
  var hexColor = [];//Array.from({ length: data.length }, (_, i) => '');
  var wf = Uint8ClampedArray.from({ length: data.length*4 }, (_, i) => 128);

  data.forEach((num, idx) => {
    let fraction = (num - 25) / (64 - 25);
   
    var color = floatToColor(fraction);
    wf[idx*4+0]=color[0];//red;
    wf[idx*4+1]=color[1];//g;
    wf[idx*4+2]=color[2];//b;
    wf[idx*4+3]=255; // прозрачность
    hexColor.push("#" + color[0].toString(16).padStart(2, '0') +
      color[1].toString(16).padStart(2, '0') +
      color[2].toString(16).padStart(2, '0'));
  });
  waterfalldata = growWaterFall(waterfalldata, wf);
  return hexColor;
}


function floatToColor(value) {
  const clamp = (num, min, max) => Math.min(Math.max(num, min), max);

  // Удостоверяемся, что значение находится в интервале [0, 1]
  value = clamp(value, 0, 1);

  // Определяем цвета, через которые будет идти переход
  const colors = [
      { r: 0, g: 0, b: 0 },       // Черный
      { r: 128, g: 0, b: 128 },   // Фиолетовый
      { r: 255, g: 0, b: 0 },     // Красный
      { r: 255, g: 165, b: 0 },   // Оранжевый
      { r: 255, g: 255, b: 0 },   // Желтый
      { r: 255, g: 255, b: 255 }  // Белый
  ];

  // Рассчитываем, сколько отрезков между цветами
  const numSections = colors.length - 1;
  // Определяем ширину одного отрезка
  const sectionWidth = 1 / numSections;
  // Определяем, в какой отрезок попадает наше значение
  const sectionIndex = Math.min(Math.floor(value / sectionWidth), numSections - 1);
  // Вычисляем позицию внутри отрезка
  const sectionPosition = (value % sectionWidth) / sectionWidth;

  // Функция линейной интерполяции для двух цветов
  const lerp = (start, end, t) => start + (end - start) * t;

  // Интерполируем цвета между двумя узлами
  const color1 = colors[sectionIndex];
  const color2 = colors[sectionIndex + 1];
  const r = Math.round(lerp(color1.r, color2.r, sectionPosition));
  const g = Math.round(lerp(color1.g, color2.g, sectionPosition));
  const b = Math.round(lerp(color1.b, color2.b, sectionPosition));

  // Возвращаем цвет в виде строки CSS
  return [r,g,b];
}

// Пример использования функции
console.log(floatToColor(0));       // Черный
console.log(floatToColor(0.5));     // Оранжевый (или близкий цвет, зависит от входного значения)
console.log(floatToColor(1));       // Белый





function radiansToDegrees(radians) {
  var degrees = radians * (180 / Math.PI);
  return degrees;
}

// Функция перевода числа в цвет
function numberToOrangeColor(num) {
  let fraction = (num - 20) / (64 - 20);
  let blue = Math.round(255 * fraction).toString(16).padStart(2, '0'); // Доля от красного
  let red = Math.round(165 * fraction).toString(16).padStart(2, '0'); // Доля от зеленого
  let green = "00"; // Синий всегда 0 для черного и оранжевого

  // Возвращаем строку цвета в формате RGB
  return "#" + red + green + blue;
}

function isNumeric(str) {
  if (typeof str != "string") return false // we only process strings!  
  return !isNaN(str) && // use type coercion to parse the _entirety_ of the string (`parseFloat` alone does not do this)...
         !isNaN(parseFloat(str)) // ...and ensure strings of whitespace fail
}

function numberToGrayScaleColor(number) {
  // Переводим число в диапазон 0 - 255
  let colorValue = Math.round((number / 64) * 255);
  // Преобразуем число в двузначный шестнадцатеричный код
  let hexString = colorValue.toString(16).padStart(2, '0');
  // Строка HEX цвета
  return "#" + hexString + hexString + hexString;
}

function setDirection(direction) {
  if (currentAlertLevel > 1) {

    var dir = 360 - direction[0] + 135; //135 - Исходный угол поворота картинки с сектором
    arrow.style.transform = "translate(-50%, -50%) rotate(" + dir + "deg)"
    document.getElementById('angle_txt').textContent = direction[1].toFixed(0) + "\u00B0";
    direct_data.pop();
    direct_data.unshift(dir);

    var value = (direct_data[0] == -1) ? dir : direct_data[0];
    
  }
}


var map;
async function initMap(lat, lon, z) {
  document.getElementById('map').innerHTML='';
  // Промис `ymaps3.ready` будет зарезолвлен, когда загрузятся все компоненты основного модуля API
  var ymaps3 = window.ymaps3
  await ymaps3.ready;

  const { YMap, YMapDefaultSchemeLayer, YMapControls, YMapListener} = ymaps3;
  // Load the control package and extract the geolocation control from it
  const {YMapGeolocationControl} = await ymaps3.import('@yandex/ymaps3-controls@0.0.1');

  // Иницилиазируем карту
  map = new YMap(
    // Передаём ссылку на HTMLElement контейнера
    document.getElementById('map'),
    
    // Передаём параметры инициализации карты
    {
      location: {
        // Координаты центра карты
        
        center: [lon, lat],
        type: 'yandex#satellite',
        // Карта будет создана без
        // элементов управления.
        controls: [],
        // Уровень масштабирования
        zoom: 18
      },
      behaviors: [],
      camera:{
        azimuth: z
      }

    },
  );

  // Добавляем слой для отображения схематической карты
  map.addChild(new YMapDefaultSchemeLayer());

  map.addChild(
    // Using YMapControls you can change the position of the control
    new YMapControls({position: 'bottom right'})
      // Add the geolocation control to the map
      .addChild(new YMapGeolocationControl({}))
  );
  // Создание объекта-слушателя.
  const mapListener = new YMapListener({
    layer: 'any',
    // Добавление обработчиков на слушатель.
    onActionEnd: ({type}) => {
      if (type === 'drag') {
        config.websettings.geo_coord[0] = map.center[1];
        config.websettings.geo_coord[1] = map.center[0];
      }else if(type === 'mouseRotate'){
        config.websettings.azimuth = map.azimuth;
      }
    }
  });

  // Добавление слушателя на карту.
  map.addChild(mapListener);

  
  
  document.getElementsByClassName("ymaps3x0--map-copyrights__container")[0].style.display = "none";
  document.getElementsByClassName("ymaps3x0--map-copyrights_right")[0].style.right = "5%";


}

export function setAll(a, v) {
  var i, n = a.length;
  for (i = 0; i < n; ++i) {
    a[i] = v;
  }
}

export function getNextJournalPage() {
  socket.emit("getNextJournalPage");
}
export function getPrevJournalPage() {
  socket.emit("getPrevJournalPage");
}

export function toast(img, label, classes, displayLength ){
  var Data = new Date();
  var Hour = Data.getHours();
  var Minutes = Data.getMinutes();
  var Seconds = Data.getSeconds();
  var time = Hour.toString().padStart(2, '0') + ":" + 
              Minutes.toString().padStart(2, '0') + ":" + 
              Seconds.toString().padStart(2, '0');
  var htmlContent=`
  <table>
  <row>
    <td><img src=${img} style="margin:0px;"></td>
    <td style="width:250px;"><span>${label}</span></td>
    <td><span style="margin-left: 10px; margin-top: 20px; font-size:12px">${time}</span></td>
  </row>
  </table>
  `
  M.toast({ html: htmlContent, classes: classes, displayLength:  displayLength})

}

async function tryToLogin(){
  socket.emit("login", document.getElementById("passw").value);
  document.getElementById("passw").value = "";
}
async function tryToLogout(){
  socket.emit("login", "");
}

window.setCoord = setCoord;
function setCoord(){
  const coords = document.getElementById('find_coord').value.split(',');
  if (coords.length!=2){
    alert(`Неверный формат координат: ${e.target.value}`);
    return;
  }
  if ((!isNumeric(coords[0]))||(!isNumeric(coords[1]))){
    alert(`Неверный формат координат: ${e.target.value}`);
    return;
  }
  map.setLocation({
    center: [parseFloat(coords[1]), parseFloat(coords[0])],
    zoom: 18
  });
}

async function saveConfig() {

  config.websettings.gis = Boolean(document.getElementById("IsGis").checked);
  config.websettings.demomode = Boolean(document.getElementById("IsDemo").checked);
  config.websettings.geo_coord[0] = map.center[1];
  config.websettings.geo_coord[1] = map.center[0];

  config.detect_json.detect.border = Number(document.getElementById("border").value);
  config.detect_json.pvcalk.NFFT = Number(document.getElementById("NFTT").value);
  config.detect_json.pvcalk.OverlapFFT = Number(document.getElementById("overlap").value);
  config.detect_json.pvcalk.N_MFCC = Number(document.getElementById("N_MFCC").value);
  config.detect_json.pvcalk.JJ = Number(document.getElementById("JJ").value);
  config.detect_json.pvcalk.F_max = Number(document.getElementById("FMAX").value);
  config.detect_json.pvcalk.F_mid = Number(document.getElementById("FMID").value);
  config.detect_json.pvcalk.F_min = Number(document.getElementById("FMIN").value);

  config.detect_json.pvcalk.F_Smp = Number(document.getElementById("FSMP").value);
  config.detect_json.pvcalk.MF_Wnd = Number(document.getElementById("MFWND").value);
  config.detect_json.detect.KK = Number(document.getElementById("KK").value);
  config.detect_json.detect.NN = Number(document.getElementById("NN").value);
  config.detect_json.detect.KN = Number(document.getElementById("KN").value);
  config.detect_json.detect.IsDynamicNet = (Number(document.getElementById("IsDynamicNet").checked)) ? 1 : 0;


  config.dir_def_json.Mic1_L = Number(document.getElementById("Mic1_L").value);
  config.dir_def_json.Mic1_Fi = Number(document.getElementById("Mic1_Fi").value);
  config.dir_def_json.Mic1_Tetta = Number(document.getElementById("Mic1_Tetta").value);
  config.dir_def_json.Mic2_L = Number(document.getElementById("Mic2_L").value);
  config.dir_def_json.Mic2_Fi = Number(document.getElementById("Mic2_Fi").value);
  config.dir_def_json.Mic2_Tetta = Number(document.getElementById("Mic2_Tetta").value);
  config.dir_def_json.Mic3_L = Number(document.getElementById("Mic3_L").value);
  config.dir_def_json.Mic3_Fi = Number(document.getElementById("Mic3_Fi").value);
  config.dir_def_json.Mic3_Tetta = Number(document.getElementById("Mic3_Tetta").value);
  config.dir_def_json.Mic4_L = Number(document.getElementById("Mic4_L").value);
  config.dir_def_json.Mic4_Fi = Number(document.getElementById("Mic4_Fi").value);
  config.dir_def_json.Mic4_Tetta = Number(document.getElementById("Mic4_Tetta").value);

  config.dir_def_json.FrameSize = Number(document.getElementById("FrameSize").value);
  config.dir_def_json.FrameOverlapPercent = Number(document.getElementById("FrameOverlapPercent").value);
  config.dir_def_json.VinerWnd = Number(document.getElementById("VinerWnd").value);
  config.dir_def_json.OutAvgLen = Number(document.getElementById("OutAvgLen").value);
  config.dir_def_json.FrameSize = Number(document.getElementById("FrameSize").value);

  socket.emit("save_detect_config", config);
  toast("/img/Settings_l.png",'Настройки сохранены', 'rounded indigo lighten-1', 2500);
  //M.toast({ html: 'Настройки сохранены', classes: 'rounded blue', displayLength: 2500 })
  await sleep(5000);
  window.location.reload()
}



var config = null;
const socket = io('http://' + document.domain + ':' + location.port);



document.addEventListener('DOMContentLoaded', function () {
  waterFallCanvas = document.getElementById("waterFallCanvas")
  document.getElementById("a_chevron_left").addEventListener('click', getPrevJournalPage);
  document.getElementById("a_chevron_right").addEventListener('click', getNextJournalPage);
  var img = document.getElementById('dronelock');
  img.addEventListener('mouseover', function(event) {
    var tooltip = document.getElementById('tooltip');
    if (!tooltip) {
      tooltip = document.createElement('div');
      tooltip.id = 'tooltip';
      document.body.appendChild(tooltip);
    }
    
    tooltip.innerHTML = `
    <div class="flex-box"><i class="material-icons">location_on</i><span>Координаты:</span></div>
    <div>${config.websettings.geo_coord}</div>
    `
    tooltip.style.display = 'block';
    tooltip.style.left = '52%';
    tooltip.style.top = '50%';
  });

  img.addEventListener('mouseout', function() {
    setTimeout(()=>{
      var tooltip = document.getElementById('tooltip');
      if (tooltip) {
        tooltip.style.display = 'none';
      }
    },5000);
  });



  setAll(direct_data, -1);
  //var angle = document.getElementById("angleCanvas");
  //var arrow = document.getElementById("arrow");


  socket.on('data', (message) => {
    // console.log(message);
    const f32 = new Float32Array(message)
    updateVerChart(f32);
  });
  socket.on('alert', (alert) => {
    setAlertLevel(alert);
    currentAlertLevel = alert
    por_color = (alert == -2) ? "red" : "blue"

  });
  socket.on('dirs', (direction) => {

    const f32 = new Float32Array(direction)
    setDirection(direction);

  });
  socket.on('por', (treshold) => {
    por = treshold
    config.detect_json.detect.border = por;
    if (currentAlertLevel == -2) {
      document.getElementById("border").value = config.detect_json.detect.border;
    }

  });

  socket.on('mess', (mess) => {
    
  });

  socket.on('connect', () => {
    console.log('Connected to server');
  });

  socket.on('disconnect', () => {
    console.log('Disconnected from server');
  });
  
  socket.on('reload', () => {
    window.location.reload();
  });
  
  socket.on('journal', (mess) => {
    //console.log(mess);
    var data = JSON.parse(mess)
    document.getElementById("page_number").innerText = data.logpagenum+'/'+data.logpage_count;
    var left = document.getElementById("page_chevron_left");
    var right = document.getElementById("page_chevron_right");
    if (data.logpagenum==1){
      left.classList.remove("waves-effect");
      left.classList.add("disabled");
    }else{
      left.classList.add("waves-effect");
      left.classList.remove("disabled");
    }
    if (data.logpagenum==data.logpage_count){
      right.classList.remove("waves-effect");
      right.classList.add("disabled");
    }else{
      right.classList.add("waves-effect");
      right.classList.remove("disabled");
    }
    var journal= document.getElementById("journalCollection");
    var html ="";
    var alert='grey';
    

    data.rows.forEach(row => {
      if (row.level == 2){
        alert = 'red';
      }else if (row.level == 1){
        alert = 'orange';
      }else if (row.level == 0){
        alert = 'green';
      }else if (row.level < 0){
        alert = 'blue';
      }
    html+=`<li class="collection-item white-text">
       <div style="display: flex;"> 
        <span style=" width: 25%; color: ${alert}; font-size:16px;">${row.time}</span>
        <span style="color: ${alert}; font-size:16px;">${row.mess}</span>     
       </div>
      </li>`;
    });
    journal.innerHTML = html;


  });

  socket.on('spectr', (data) => {
    const f32 = new Float32Array(data)
    updateSpectrChart(f32);
});

  socket.on('login', (login) => {
    var specs = document.getElementsByClassName("spec");
    Array.from(specs).forEach((spec)=>{
      //spec.style.visibility = login?"visible":none;
      spec.hidden = !login
    });
    document.getElementById("enter_btn").href = login?'#out_modal':'#enter_modal';
  });

  socket.on('detect_config', (c) => {
    console.log(c);
    config = c;

    if (config.websettings.gis){
      var coord = config.websettings.geo_coord
      initMap(coord[0], coord[1], config.websettings.azimuth);
    }else{
      var canvas = document.createElement('canvas');
      document.getElementById('map').prepend(canvas);
      var img = new Image();

      img.onload = function() {
        context = canvas.getContext("2d");
	      context.drawImage(img, 10, 10);
      };
      img.src = config.websettings.back_picture;
    }
    document.getElementById("IsGis").checked = config.websettings.gis;
    document.getElementById("IsDemo").checked = config.websettings.demomode;



    document.getElementById("trainingstat").innerText = "Текущий файл: "+ config.trainingstat;

    document.getElementById("border").value = config.detect_json.detect.border;
    document.getElementById("NFTT").value = config.detect_json.pvcalk.NFFT;
    document.getElementById("overlap").value = config.detect_json.pvcalk.OverlapFFT;
    document.getElementById("N_MFCC").value = config.detect_json.pvcalk.N_MFCC;
    document.getElementById("JJ").value = config.detect_json.pvcalk.JJ;
    document.getElementById("FMAX").value = config.detect_json.pvcalk.F_max;
    document.getElementById("FMID").value = config.detect_json.pvcalk.F_mid;
    document.getElementById("FMIN").value = config.detect_json.pvcalk.F_min;

    document.getElementById("FSMP").value = config.detect_json.pvcalk.F_Smp;
    document.getElementById("MFWND").value = config.detect_json.pvcalk.MF_Wnd;
    document.getElementById("KK").value = config.detect_json.detect.KK;
    document.getElementById("NN").value = config.detect_json.detect.NN;
    document.getElementById("KN").value = config.detect_json.detect.KN;
    document.getElementById("IsDynamicNet").checked = (config.detect_json.detect.IsDynamicNet > 0);


    document.getElementById("Mic1_L").value = config.dir_def_json.Mic1_L;
    document.getElementById("Mic1_Fi").value = config.dir_def_json.Mic1_Fi;
    document.getElementById("Mic1_Tetta").value = config.dir_def_json.Mic1_Tetta;
    document.getElementById("Mic2_L").value = config.dir_def_json.Mic2_L;
    document.getElementById("Mic2_Fi").value = config.dir_def_json.Mic2_Fi;
    document.getElementById("Mic2_Tetta").value = config.dir_def_json.Mic2_Tetta;
    document.getElementById("Mic3_L").value = config.dir_def_json.Mic3_L;
    document.getElementById("Mic3_Fi").value = config.dir_def_json.Mic3_Fi;
    document.getElementById("Mic3_Tetta").value = config.dir_def_json.Mic3_Tetta;
    document.getElementById("Mic4_L").value = config.dir_def_json.Mic4_L;
    document.getElementById("Mic4_Fi").value = config.dir_def_json.Mic4_Fi;
    document.getElementById("Mic4_Tetta").value = config.dir_def_json.Mic4_Tetta;

    document.getElementById("FrameSize").value = config.dir_def_json.FrameSize;
    document.getElementById("FrameOverlapPercent").value = config.dir_def_json.FrameOverlapPercent;
    document.getElementById("VinerWnd").value = config.dir_def_json.VinerWnd;
    document.getElementById("OutAvgLen").value = config.dir_def_json.OutAvgLen;
    document.getElementById("FrameSize").value = config.dir_def_json.FrameSize;
    M.updateTextFields();
    M.FormSelect.init(document.querySelectorAll('select'), {});


    var df = parseFloat(config.detect_json.pvcalk.F_Smp / config.detect_json.pvcalk.NFFT);
    var L = Math.round((config.detect_json.pvcalk.F_max - config.detect_json.pvcalk.F_min) / df);
    spectrChart.data.labels = Array.from({ length: L }, (_, i) => config.detect_json.pvcalk.F_min + Math.round(i * df));
    console.log(df)
    console.log(L)
    console.log(spectrChart.data.labels)



  });



  M.FormSelect.init(document.querySelectorAll('select'), {});
  M.Modal.init(document.querySelectorAll('.modal'), {});
  M.Dropdown.init(document.querySelectorAll('.dropdown-trigger'), {
    constrainWidth: false,
    coverTrigger: false
  });


  document.getElementById("map_blk_sw").onchange = (ev) => {
    document.getElementById("coord_search").style.visibility = ev.target.checked?"hidden":"visible"
    if (!ev.target.checked) {
      map.setBehaviors(['drag', 'scrollZoom', 'dblClick', 'mouseRotate', 'mouseTilt']);
      toast("/img/Map_l.png",'Карта разблокирована', 'rounded indigo lighten-1', 2500);
    } else {
      map.setBehaviors(['scrollZoom']);
      toast("/img/Map_l.png",'Карта заблокирована', 'rounded indigo lighten-1', 2500);
      saveConfig();
    }
  };

  document.getElementById("saveDetectConfigbtn").onclick = saveConfig;
  document.getElementById("enterbtn").onclick = tryToLogin;
  document.getElementById("outbtn").onclick = tryToLogout;
  document.getElementById("find_coord").addEventListener("keydown", function (e) {
    if (e.code === "Enter") {  //checks whether the pressed key is "Enter"
      setCoord();
    }
  });
  document.getElementById("passw").addEventListener("keydown", function (e) {
    if (e.code === "Enter") {  //checks whether the pressed key is "Enter"
      tryToLogin();
      var modal = document.getElementById("enter_modal");
      M.Modal.getInstance(modal).close();
    }
  });


});




