import { io, status, addlogs, getLogs, detect_config } from './app.mjs';

export async function parseJsonData(data) {
    // Отправляем данные по сокету всем клиентам
    try {
        var report ={}
        if (detect_config.websettings.demomode){
            report = getDemoReport()
        }else{
            report = JSON.parse(data);
        }

        

        //console.log(report);
        io.emit('data', report.dots);
        io.emit('por', report.brd);
        status.por = report.brd;
        if ("alert" in report) {
            if (report.alert == -1) {
                if ("err" in report) {
                    if (report.err != status.currentMessage) {
                        status.currentMessage = report.err;
                        io.emit('mess', status.currentMessage);
                    }
                } else {
                    status.currentMessage = "Нет связи с МС!";
                    io.emit('mess', status.currentMessage);
                }
            } else if (report.alert == -2) {
                status.currentMessage = "Калибровка";
            } else if (report.alert == 0) {
                status.currentMessage = "Норма";
            } else if (report.alert == 1) {
                status.currentMessage = "Внимание!";
            } else if (report.alert == 2) {
                status.currentMessage = "Дрон обнаружен!";
            }
            if ( status.alert != report.alert) {
                io.emit('alert', report.alert);
                status.alert = report.alert;

                //var datetime = new Date().toDateString() + " " + new Date().LocaleTimeString;
                addlogs();
                io.emit('journal', JSON.stringify(await getLogs()));
            }
        }
        if ("dirs" in report) {
            status.dirs = report.dirs;
            io.emit('dirs', report.dirs);
        }
    } catch (e) {
        console.log(data);
        console.log(e);
    }
}

function getDemoReport(){

    const report = {}
    // Получаем текущее время
    var current_time = Date.now()/1000
//#print(counter)

//# Вычисляем значение синуса
var sin_value1 = 0.7*Math.abs((Math.cos(current_time*0.2))/2 + (Math.sin(current_time*0.05)+2)/3 + getRandomArbitrary(-0.05, 0.05))
var sin_value2 = 0.7*Math.abs((Math.cos(current_time*0.2))/2 + (Math.sin(current_time*0.05)+2)/3 + getRandomArbitrary(-0.05, 0.05))
var sin_value3 = 0.7*Math.abs((Math.cos(current_time*0.2))/2 + (Math.sin(current_time*0.05)+2)/3 + getRandomArbitrary(-0.05, 0.05))
var sin_value4 = 0.7*Math.abs((Math.cos(current_time*0.2))/2 + (Math.sin(current_time*0.05)+2)/3 + getRandomArbitrary(-0.05, 0.05))
sin_value1 = (sin_value1 > 1)?1: sin_value1;
sin_value2 = (sin_value2 > 1)?1:  sin_value2
sin_value3 = (sin_value3 > 1)?1:  sin_value3
sin_value4 = (sin_value4 > 1)?1:  sin_value4
    
var azimuth = Math.abs(Math.sin(current_time*0.3)*90) + 20
var angle = Math.abs(Math.cos(current_time*0.1)*45) + 10



report.dots = [sin_value1,sin_value2,sin_value3,sin_value4]
report.dirs = [azimuth, angle]
report.brd = 0.5
    if (sin_value1 > status.por){
                    report.alert = 2
    }
    else{
                    report.alert = 0
    }
    
 return report
}
function getRandomArbitrary(min, max) {
    return Math.random() * (max - min) + min;
}