import type {BehaviorType} from '@yandex/ymaps3-types';
interface BehaviorControlProps {
    behaviorName: string;
    checked: boolean;
    tooltip: boolean;
    onChange: (event: Event) => void;
}
class BehaviorControl extends ymaps3.YMapComplexEntity<BehaviorControlProps> {
    private _element: HTMLDivElement;
    private _detachDom: () => void;

    // Method for create a DOM control element
    _createElement(props: BehaviorControlProps) {
        const {behaviorName, checked, tooltip, onChange} = props;

        // Create a root element
        const behaviorControl = document.createElement('div');
        behaviorControl.className = 'behaviorControl';

        // Create a title element
        const title = document.createElement('div');
        title.className = 'behaviorControl__title';
        title.textContent = behaviorName;
        behaviorControl.appendChild(title);

        // Create a tooltip element if necessary
        if (tooltip) {
            const tooltipElement = document.createElement('div');
            tooltipElement.className = 'behaviorControl__tooltip';
            tooltipElement.setAttribute(
                'tooltip-text',
                'To reproduce this behavior, hold down ctrl/command + left mouse button.'
            );

            const tooltipIcon = document.createElement('img');
            tooltipIcon.src = '../tooltip-icon.svg';

            tooltipElement.appendChild(tooltipIcon);
            behaviorControl.appendChild(tooltipElement);
        }

        // Create a label element
        const label = document.createElement('label');
        label.className = 'behaviorControl__label';
        label.htmlFor = behaviorName;

        // Create an input element (checkbox)
        const input = document.createElement('input');
        input.type = 'checkbox';
        input.id = behaviorName;
        input.checked = checked;
        input.addEventListener('change', onChange);

        // Create a slider element
        const slider = document.createElement('div');
        slider.className = 'behaviorControl__slider';

        // Add elements to the label
        label.appendChild(input);
        label.appendChild(slider);

        // Add the label to the root element
        behaviorControl.appendChild(label);

        return behaviorControl;
    }
}