import express from 'express';
import AudioStream from 'node-rtsp-stream';

const app = express();
const stream = new AudioStream({
  name: 'audio-stream',
  streamUrl: 'rtsp://192.168.1.210:8554/',
  wsPort: 9999, // WebSocket порт, который будет использоваться для потока
  ffmpegOptions: { // опциональные параметры FFmpeg
      '-f': 'mpegts',
      '-codec:v': 'mpeg1video',
      '-codec:a': 'mp2'
    }
});
stream;
//const { proxy, scriptUrl } = require('rtsp-relay')(app);

/*const handler = proxy({
  url: `rtsp://192.168.1.210:8554/`,
  // if your RTSP stream need credentials, include them in the URL as above
  verbose: false,
});*/

// the endpoint our RTSP uses
//app.ws('/api/stream', handler);

// this is an example html page to view the stream
app.get('/', (req, res) =>
  res.send(`
  <html>
  <body>
    <canvas id="canvas"></canvas>
  </body>
  <script src="https://cdn.jsdelivr.net/npm/jsmpeg-player@3.0.3/build/jsmpeg-player.min.js"></script>
  <script type="text/javascript">
  const timerId = setTimeout(() => {
    console.log('Прошла 1 секунда')
  
    player = new JSMpeg.Player('ws://192.168.1.60:9999', {
      canvas: document.getElementById('canvas'), // Canvas should be a canvas DOM element
      loop: true,
      video: false, 
      autoplay: true
    })	
    console.log('Прошла 1 секунда')
  }, 3000)
  </script>
  </html>
`),
);

app.listen(2000);