#!/usr/bin/env bash

# The script to create DRONELOCK.WEB docker image
set -e
set -u

cd "$(dirname "$0")"

INSTALL_DIR="../install"
DIST_DIR="${INSTALL_DIR}/dist"
PACKAGE_NAME="dronelock"
DIST_PACKAGE_DIR="${DIST_DIR}/${PACKAGE_NAME}"
PACKAGE="${PACKAGE_NAME}.tar.gz"


GREEN="\033[0;32m"
DEFAULT="\033[39m"

print_green(){
  echo -e "${GREEN}${1}${DEFAULT}"
}

print_green "Packaging of DRONELOCK started"
rm -rf "${DIST_PACKAGE_DIR}"
mkdir -p "${DIST_PACKAGE_DIR}"

print_green "Creating package"
cp -R ../{public,scripts,app.mjs,index.html,install.sh,main.js,package-lock.json,package.json,vite.config.js} "${DIST_PACKAGE_DIR}"
chmod +x "${DIST_PACKAGE_DIR}"/install.sh
tar --totals -czf "${DIST_DIR}/${PACKAGE}" -C "${DIST_DIR}" "${PACKAGE_NAME}"
print_green "Calculating checksum"
cd ${DIST_DIR}
sha512sum "${PACKAGE}" > "${PACKAGE}.sha512"
cd - > /dev/null

print_green "Removing intermediate files"
rm -rf "${DIST_PACKAGE_DIR}"

print_green "Success. Distribution kit was stored to \"scripts/install/dist\" directory."
