import json
import os
import random
import time
import math
import struct
import configparser


#config = configparser.ConfigParser()
#config.read('/opt/RMS/detector/settings/detect.json')
#por = float(config['config']['por'])
por = None
with open('/opt/RMS/detector/settings/detect.json') as f:
    data = json.load(f)
    por = float(data['detect']['border'])

calibration = True if por < 0 else False

dots_path = "/tmp/dots2.fifo"  # Укажите путь к вашему FIFO

# Создаем FIFO файл, если его еще нет
if not os.path.exists(dots_path):
    os.mkfifo(dots_path)

#print(dots_path)
with open(dots_path, 'w') as dots_file:

    message = 'Норма'    
    counter = 0

    por_maximum = 0
    # Главный цикл
    while True:
        try:
            report = {}
            # Получаем текущее время
            current_time = time.time()
            #print(counter)

            # Вычисляем значение синуса
            sin_value1 = 0.7*abs((math.cos(current_time*0.2))/2 + (math.sin(current_time*0.05)+2)/3 + random.uniform(-0.05, 0.05))
            sin_value2 = 0.7*abs((math.cos(current_time*0.2))/2 + (math.sin(current_time*0.05)+2)/3 + random.uniform(-0.05, 0.05))
            sin_value3 = 0.7*abs((math.cos(current_time*0.2))/2 + (math.sin(current_time*0.05)+2)/3 + random.uniform(-0.05, 0.05))
            sin_value4 = 0.7*abs((math.cos(current_time*0.2))/2 + (math.sin(current_time*0.05)+2)/3 + random.uniform(-0.05, 0.05))
            sin_value1 = 1 if sin_value1 > 1 else sin_value1
            sin_value2 = 1 if sin_value2 > 1 else sin_value2
            sin_value3 = 1 if sin_value3 > 1 else sin_value3
            sin_value4 = 1 if sin_value4 > 1 else sin_value4
                
            azimuth = abs(math.sin(current_time*0.3)*90) + 20
            angle = abs(math.cos(current_time*0.1)*45) + 10



            report['dots'] = [sin_value1,sin_value2,sin_value3,sin_value4]
            report['dirs'] = [azimuth, angle]
            if calibration:
                report['alert'] = -2
                por_maximum = max(por_maximum,sin_value1,sin_value2,sin_value3,sin_value4)
                report['brd'] = por_maximum*1.05
            else:
                report['brd'] = por
                if sin_value1 > por:
                    if counter < 0:
                        counter = 0
                    elif 0 <= counter <= 10:
                        if message != "Внимание":
                            message = "Внимание"
                            try:
                                print(message)
                                report['alert'] = 1
                            except Exception as e:
                                print(f'{e}')
                        counter += 1
                    elif counter > 3:
                        if message != "Дрон обнаружен!":
                            message = "Дрон обнаружен!"
                            try:
                                print(message)
                                report['alert'] = 2
                            except Exception as e:
                                print(f'{e}')
                else:
                    if counter > 0:
                        counter = 0
                    elif -10 <= counter <= 0:
                        if message != "Внимание":
                            message = "Внимание"
                            try:
                                print(message)
                                report['alert'] = 1
                            except Exception as e:
                                print(f'{e}')
                        counter -= 1
                    elif counter < 10:
                        if message != "Норма":
                            message = "Норма"
                            try:
                                report['alert'] = 0
                            except Exception as e:
                                print(f'{e}')


                # Записываем бинарное представление значения синуса в FIFO файл

            try:
                #print(sin_value)
                dots_file.write(json.dumps(report))
                dots_file.flush()  # Принудительно сбрасываем буфер
                #print(f"Записано значение синуса: {sin_value}")
            except Exception as e:
                print(f'{e}')
            # Ждем 10 секунд перед следующей записью
            time.sleep(0.2)
        except Exception as e:
            print(f'{e}')
